# SuperLU lib usually requires linking to a blas library.
# It is up to the user of this module to find a BLAS and link to it.

# From eigen

MACRO(find_superlu_variant SUPERLU_VARIANT SUPERLU_VARIANT_LIB SUPERLU_VARIANT_HEADER)

if (${SUPERLU_VARIANT}_INCLUDE_DIR AND ${SUPERLU_VARIANT}_LIBRARIES)
  set(${SUPERLU_VARIANT}_FIND_QUIETLY TRUE)
endif (${SUPERLU_VARIANT}_INCLUDE_DIR AND ${SUPERLU_VARIANT}_LIBRARIES)

find_package(PkgConfig)
include(LibFindMacros)

# Use pkg-config to get hints about paths
pkg_check_modules(${SUPERLU_VARIANT} QUIET ${SUPERLU_VARIANT_LIB})

IF(${SUPERLU_VARIANT}_FOUND)
  SET(${SUPERLU_VARIANT}_INCLUDE_DIR ${${SUPERLU_VARIANT}_INCLUDE_DIRS})
  IF(${SUPERLU_VARIANT}_LIBRARY_DIRS)
    SET(${SUPERLU_VARIANT}_LIBDIR ${${SUPERLU_VARIANT}_LIBRARY_DIRS})
  ELSE(${SUPERLU_VARIANT}_LIBRARY_DIRS)
    SET(${SUPERLU_VARIANT}_LIBDIR " ")
  ENDIF(${SUPERLU_VARIANT}_LIBRARY_DIRS)
ENDIF(${SUPERLU_VARIANT}_FOUND)

find_path(${SUPERLU_VARIANT}_INCLUDE_DIR
  NAMES
  ${SUPERLU_VARIANT_HEADER}
  PATHS
  $ENV{${SUPERLU_VARIANT}DIR}
  PATH_SUFFIXES
  ${SUPERLU_VARIANT_LIB}
)

find_library(${SUPERLU_VARIANT}_LIBRARIES ${SUPERLU_VARIANT_LIB} PATHS $ENV{${SUPERLU_VARIANT}DIR})

if(${SUPERLU_VARIANT}_LIBRARIES)

  if (NOT ${SUPERLU_VARIANT}_LIBDIR)
    get_filename_component(${SUPERLU_VARIANT}_LIBDIR ${${SUPERLU_VARIANT}_LIBRARIES} PATH)
  endif(NOT ${SUPERLU_VARIANT}_LIBDIR)

endif(${SUPERLU_VARIANT}_LIBRARIES)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(${SUPERLU_VARIANT} DEFAULT_MSG
                                  ${SUPERLU_VARIANT}_INCLUDE_DIR ${SUPERLU_VARIANT}_LIBRARIES )

STRING(TOUPPER ${SUPERLU_VARIANT} ${SUPERLU_VARIANT}_UPPER)
if(${${SUPERLU_VARIANT}_UPPER}_FOUND)
  set(${SUPERLU_VARIANT}_FOUND ${${${SUPERLU_VARIANT}_UPPER}_FOUND} CACHE STRING "${SUPERLU_VARIANT} found value")
  message(STATUS "${${SUPERLU_VARIANT}_UPPER} variant ${${${SUPERLU_VARIANT}_UPPER}_FOUND}")
  message(STATUS "${SUPERLU_VARIANT}_FOUND: ${${SUPERLU_VARIANT}_FOUND}")
endif()
set (${SUPERLU_VARIANT}_INCLUDE_DIR ${${SUPERLU_VARIANT}_INCLUDE_DIR} CACHE STRING "${SUPERLU_VARIANT} include path")
set (${SUPERLU_VARIANT}_LIBRARIES ${${SUPERLU_VARIANT}_LIBRARIES} CACHE STRING "${SUPERLU_VARIANT} libraries")
set (${${SUPERLU_VARIANT}_UPPER}_INCLUDE_DIR ${${SUPERLU_VARIANT}_INCLUDE_DIR} CACHE STRING "${SUPERLU_VARIANT} include path")
set (${${SUPERLU_VARIANT}_UPPER}_LIBRARIES ${${SUPERLU_VARIANT}_LIBRARIES} CACHE STRING "${SUPERLU_VARIANT} libraries")


ENDMACRO()

