/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebKitDOMTestNode.h"

#include "CSSImportRule.h"
#include "DOMObjectCache.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "ExceptionCodeDescription.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTestNodePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMTestNode* kit(WebCore::TestNode* obj)
{
    return WEBKIT_DOM_TEST_NODE(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::TestNode* core(WebKitDOMTestNode* request)
{
    return request ? static_cast<WebCore::TestNode*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTestNode* wrapTestNode(WebCore::TestNode* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEST_NODE(g_object_new(WEBKIT_DOM_TYPE_TEST_NODE, "core-object", coreObject, nullptr));
}

} // namespace WebKit

static gboolean webkit_dom_test_node_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::TestNode* coreTarget = static_cast<WebCore::TestNode*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    gboolean result = coreTarget->dispatchEventForBindings(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
    return result;
}

static gboolean webkit_dom_test_node_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GClosure* handler, gboolean useCapture)
{
    WebCore::TestNode* coreTarget = static_cast<WebCore::TestNode*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, useCapture);
}

static gboolean webkit_dom_test_node_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GClosure* handler, gboolean useCapture)
{
    WebCore::TestNode* coreTarget = static_cast<WebCore::TestNode*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, useCapture);
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_test_node_dispatch_event;
    iface->add_event_listener = webkit_dom_test_node_add_event_listener;
    iface->remove_event_listener = webkit_dom_test_node_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMTestNode, webkit_dom_test_node, WEBKIT_DOM_TYPE_NODE, G_IMPLEMENT_INTERFACE(WEBKIT_DOM_TYPE_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_NAME,
};

static void webkit_dom_test_node_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebKitDOMTestNode* self = WEBKIT_DOM_TEST_NODE(object);

    switch (propertyId) {
    case PROP_NAME:
        webkit_dom_test_node_set_name(self, g_value_get_string(value));
        break;
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_test_node_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebKitDOMTestNode* self = WEBKIT_DOM_TEST_NODE(object);

    switch (propertyId) {
    case PROP_NAME:
        g_value_take_string(value, webkit_dom_test_node_get_name(self));
        break;
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_test_node_class_init(WebKitDOMTestNodeClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_test_node_set_property;
    gobjectClass->get_property = webkit_dom_test_node_get_property;

    g_object_class_install_property(
        gobjectClass,
        PROP_NAME,
        g_param_spec_string(
            "name",
            "TestNode:name",
            "read-write gchar* TestNode:name",
            "",
            WEBKIT_PARAM_READWRITE));

}

static void webkit_dom_test_node_init(WebKitDOMTestNode* request)
{
    UNUSED_PARAM(request);
}

gchar* webkit_dom_test_node_get_name(WebKitDOMTestNode* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_NODE(self), 0);
    WebCore::TestNode* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
}

void webkit_dom_test_node_set_name(WebKitDOMTestNode* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_NODE(self));
    g_return_if_fail(value);
    WebCore::TestNode* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setName(convertedValue);
}

