#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>

VERSION=$(dpkg-parsechangelog | sed -ne 's,^Version: \(.*\)-.*,\1,p')
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
JAR=jcip-annotations-src.jar
DIR=jcip-annotations-$VERSION
TAR=../${SOURCE}_${VERSION}.orig.tar.gz

wget http://www.jcip.net/$JAR

# clean up the upstream tarball
mkdir $DIR
(cd $DIR && jar -x -f ../$JAR)
tar -c -z -f $TAR $DIR
rm -rf $JAR $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

