#ifndef ERIS_PERL_CONVERSION_H
#define ERIS_PERL_CONVERSION_H

#include "refcount.h"
#include "perlentity.h"
#include "roomhandle.h"

#include <Eris/Person.h>

class PersonHandle
{
 public:
  PersonHandle(Eris::Person *p) : _p(p) {connectionRef(p->getLobby()->getConnection());}
  ~PersonHandle() {connectionUnref(_p->getLobby()->getConnection());}

  operator Eris::Person*() const {return _p;}

 private:
  Eris::Person *_p;
};

template<>
struct HandleType<Eris::Person*>
{
  typedef PersonHandle type;
};

using Eris::Room;
using Eris::Person;
using Eris::Entity;
// The following autogenerated header file is not complete, and should
// only be included here
#include "conversion_wrapper.h"

#endif // ERIS_PERL_CONVERSION_H
